#include <stdio.h>
#include <stdlib.h>

void sort(int arr[])
{
    int key, j;
    for (int i = 1; i < 7; i++)
    {
        key = arr[i];
        j = i - 1;
        // Move elements of arr[0..i-1],
        // that are greater than key,
        // to one position ahead of their
        // current position
        while ((j >= 0) && (arr[j] > key))
        {
            arr[j + 1] = arr[j];
            j = j - 1;
        }
        arr[j + 1] = key;
    }
}


int main()
{
    //has to be 7 because we know for a fact we have 7 elements:
    //x, y, z, x+y, x+z, y+z, x+y+z.
    //0<=x<=y<=z is always true.
    int arr[7];
    //creating the array
    for(int i = 0; i < 7; i++)
    {
        scanf("%i", &arr[i]);
    }
    //We know for a fact that x is ALWAYS the lowest value.
    //We also know for a fact that x+y+z is larger than every other value.
    //For starters, let's sort the array.
    sort(arr);
    //We now know that x is the first element of the array.
    int x = arr[0];
    //We also know that y is the 2nd element of the array,
    //since z >= y >= x. x+y+z is the greatest element, so it can't
    //be smaller than y. x+y and y+z both contain y in them, so
    //they're greater than or equal to y. x+z contains z, which is
    //greater than or equal to y.
    int y = arr[1];
    //We also know that the greatest element is x+y+z.
    int sum = arr[6];
    //So then we also know that z is x+y+z-x-y
    int z = sum - (y + x);
    printf("%i %i %i", x, y, z);
}